class MH2_Pickup_Health25 extends MH2_Pickup_Health;

var() int HealingAmount;

event float BotDesireability(Pawn Bot)
{
return ( 0 ); 
}

function PlayPickupMessage(Pawn Other)
{
	Other.ReceiveLocalizedMessage( class'PickupMessagePlus', 0, None, None, Self.Class );
}

auto state Pickup
{	
	function Touch( actor Other )
		{
		local int HealMax;
		local PlayerPawn P;
			
		if ( ValidTouch(Other) && Other.IsA('PlayerPawn')) 
			{	
			P = PlayerPawn(Other);	
			HealMax = Info_PRI(P.PlayerReplicationInfo).HealthMax;

			if (P.Health < HealMax) 
				{
				if (Level.Game.LocalLog != None)
					Level.Game.LocalLog.LogPickup(Self, P);
				if (Level.Game.WorldLog != None)
					Level.Game.WorldLog.LogPickup(Self, P);
				P.Health += HealingAmount;
				if (P.Health > HealMax) P.Health = HealMax;
				PlayPickupMessage(P);
				PlaySound (PickupSound,,2.5);
				Other.MakeNoise(0.2);		
				SetRespawn();
				}
			}
		}
}

defaultproperties
{
     DrawScale=0.6
     HealingAmount=25
     PickupMessage="You picked up 25 Health points."
     ItemName="MH2 Health"
     RespawnTime=30.000000
     PickupViewMesh=Mesh'MH2_Health'
     PickupSound=Sound'Botpack.Pickups.UTHealth'
     Mesh=Mesh'MH2_Health'
     ScaleGlow=2.000000
     CollisionRadius=16.000000
     CollisionHeight=16.000000
     MultiSkins(0)=Texture'eol.epanel4'
     MultiSkins(1)=Texture'eol.espot'
     MultiSkins(2)=Texture'UnrealShare.Belt_fx.UDamageFX'
}
